/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.commands.commands;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.commands.Command;
import Krasnodar.rockstarnew.systems.commands.CommandBuilder;
import Krasnodar.rockstarnew.systems.commands.CommandContext;
import Krasnodar.rockstarnew.systems.commands.ParameterBuilder;
import Krasnodar.rockstarnew.systems.commands.ValidationResult;
import Krasnodar.rockstarnew.systems.modules.Module;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.game.TextUtility;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;
import ru.kotopushka.compiler.sdk.annotations.Compile;

public class BindCommand {
    @Compile
    public Command command() {
        List<String> moduleNames = Rockstar.getInstance().getModuleManager().getModules().stream().map(module -> module.getName().replace(" ", "")).toList();
        List<String> keyNames = this.getAvailableKeyNames();
        return CommandBuilder.begin("bind", commandBuilder -> commandBuilder.aliases("binds", "\u0431\u0438\u043d\u0434").desc("\u0411\u0438\u043d\u0434 \u043d\u0430 \u043c\u043e\u0434\u0443\u043b\u044c")).param("action", p -> p.literal("add", "delete", "remove", "create", "list")).param("module", p -> p.optional().validator(ParameterBuilder.MODULE).suggests(moduleNames)).param("key", p -> p.optional().validator(text -> (ValidationResult)((Object)(text.isBlank() ? ValidationResult.error("key is empty") : ValidationResult.ok(text)))).suggests(keyNames)).handler(this::handle).build();
    }

    @Compile
    private void handle(CommandContext context) {
        String action = (String)context.arguments().getFirst();
        Module module = (Module)context.arguments().get(1);
        String keyStr = (String)context.arguments().get(2);
        if (action.equalsIgnoreCase("list")) {
            List<Module> modules = Rockstar.getInstance().getModuleManager().getModules().stream().filter(mx -> mx.getKey() != -1).toList();
            if (modules.isEmpty()) {
                MessageUtility.info(class_2561.method_30163((String)"\u0421\u043f\u0438\u0441\u043e\u043a \u0431\u0438\u043d\u0434\u043e\u0432 \u043f\u0443\u0441\u0442"));
            } else {
                MessageUtility.info(class_2561.method_30163((String)"\u0421\u043f\u0438\u0441\u043e\u043a \u0431\u0438\u043d\u0434\u043e\u0432:"));
                for (int i = 0; i < modules.size(); ++i) {
                    Module m = modules.get(i);
                    MessageUtility.info(class_2561.method_30163((String)(String.valueOf(class_124.field_1080) + "[" + (i + 1) + "] " + String.valueOf(class_124.field_1068) + m.getName() + String.valueOf(class_124.field_1080) + " (" + TextUtility.getKeyName(m.getKey()) + ")")));
                }
            }
        } else if (module == null) {
            MessageUtility.error(class_2561.method_30163((String)"\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d"));
        } else if (!action.equalsIgnoreCase("add") && !action.equalsIgnoreCase("create")) {
            if (action.equalsIgnoreCase("delete") || action.equalsIgnoreCase("remove")) {
                module.setKey(-1);
                MessageUtility.info(class_2561.method_30163((String)("\u0411\u0438\u043d\u0434 \u0443\u0434\u0430\u043b\u0435\u043d \u0441 \u043c\u043e\u0434\u0443\u043b\u044f " + module.getName())));
            }
        } else {
            if (keyStr == null) {
                MessageUtility.error(class_2561.method_30163((String)"\u041a\u043b\u0430\u0432\u0438\u0448\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430"));
                return;
            }
            int keyCode = this.getKeyCodeFromString(keyStr);
            if (keyCode == -1) {
                MessageUtility.error(class_2561.method_30163((String)("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430: " + keyStr)));
                return;
            }
            module.setKey(keyCode);
            MessageUtility.info(class_2561.method_30163((String)("\u0411\u0438\u043d\u0434 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0430 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 " + TextUtility.getKeyName(keyCode))));
        }
    }

    private int getKeyCodeFromString(String input) {
        if (input != null && !input.isBlank()) {
            input = input.toUpperCase(Locale.ROOT).replace(" ", "_");
            try {
                return (Integer)GLFW.class.getField("GLFW_KEY_" + input).get(null);
            }
            catch (Exception var3) {
                return -1;
            }
        }
        return -1;
    }

    @Compile
    private List<String> getAvailableKeyNames() {
        return Stream.of(GLFW.class.getFields()).map(Field::getName).filter(name -> name.startsWith("GLFW_KEY_")).map(name -> name.substring("GLFW_KEY_".length())).filter(name -> !name.matches("LAST|UNKNOWN|WORLD_\\d+")).collect(Collectors.toList());
    }
}

